﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.EntityModels
{
    public class PediatricEncounterFullTranscriptModel
    {
        /// <summary>
        /// Gets or sets the pediatric encounter id.
        /// </summary>
        public int PediatricEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the encounter date.
        /// </summary>
        public DateTime EncounterDate { get; set; }



        /// <summary>
        /// Gets or sets the vitals.
        /// </summary>
        public string? Vitals { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the educations.
        /// </summary>
        public string? Educations { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string? ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the provider no.
        /// </summary>
        public string? ProviderNo { get; set; }

        /// <summary>
        /// Gets or sets the specialization name.
        /// </summary>
        public string? SpecializationName { get; set; }

        /// <summary>
        /// Gets or sets the practice name.
        /// </summary>
        public string? PracticeName { get; set; }

        /// <summary>
        /// Gets or sets the practice location.
        /// </summary>
        public string? PracticeLocation { get; set; }

        /// <summary>
        /// Gets or sets the signature.
        /// </summary>
        public string? Signature { get; set; }

        /// <summary>
        /// Gets or sets the clinic picture.
        /// </summary>
        public string? ClinicPicture { get; set; }

        /// <summary>
        /// Gets or sets the AppointmentTimeString
        /// </summary>
        public string? AppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string? PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        public char? PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string? PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail url.
        /// </summary>
        public string? PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the patient age.
        /// </summary>
        public short? PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the patient date of birth.
        /// </summary>
        public DateTime? PatientDateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the patient country code.
        /// </summary>
        public string? PatientCountryCode { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; }
        /// <summary>
        /// Gets or Sets the ivf Encounter
        /// </summary>
       
        
        /// <summary>
        /// Gets or Sets the measurements
        /// </summary>
        public string? Measurements { get; set; }
        /// <summary>
        /// Gets or Sets the NeonatalRisk
        /// </summary>
        public string? NeonatalRisk{ get; set; }
        /// <summary>
        /// Gets or Sets the PediatricRisk 
        /// </summary>
        public string? PediatricRisk { get; set; }
        /// <summary>
        /// Gets or Sets the Syndrome
        /// </summary>
        /// 
        public string? ClinicalExamination { get; set; }
        /// <summary>
        /// Gets or Sets the Syndrome
        /// </summary>
        /// 
        public string? DownSyndromeFollowUp { get; set; }
        /// <summary>
        /// Gets or Sets the Syndrome
        /// </summary>
        /// 
        public string? HighRiskIntial { get; set; }
        /// <summary>
        /// Gets or Sets the Syndrome
        /// </summary>
        /// 
        public string? Syndrome { get; set; }
        /// <summary>
        /// Gets or Sets the Syndrome
        /// </summary>
        /// 
        public string? OrderPrescription { get; set; }
        /// <summary>
        /// Gets or Sets the Allergies
        /// </summary>
        /// 
        public string? Allergies { get; set; }
        /// <summary>
        /// Gets or Sets the RefferalOrder 
        /// </summary>
        /// 
        public string? RefferalOrder { get; set; }
        /// <summary>
        /// Gets or Sets the MChat
        /// </summary>
        ///
        public string? MChat { get; set; }
        /// <summary>
        /// Gets or Sets the FamilyHistory
        /// </summary>
        ///
        public string? FamilyHistory { get; set; }
        /// <summary>
        /// Gets or Sets the BirthHistory
        /// </summary>
        ///
        public string? BirthHistory { get; set; }
        /// <summary>
        /// Gets or Sets the SpecialFeatures
        /// </summary>
        ///
        public string? SpecialFeatures { get; set; }
        /// <summary>
        /// Gets or Sets the UMR No
        /// </summary>
      
        public string? UMRNo { get; set; }
        /// <summary>
        /// Gets or Sets the  Provider Email
        /// </summary>
       
        public string? Email { get; set; }
        /// <summary>
        /// Gets or Sets the diagnosis order
        /// </summary>
        public string? DiagnosisOrder { get; set; }
        /// <summary>
        /// Gets or Sets the next visit order
        /// </summary>
        public string? NextVisitOrder { get; set; }
        /// <summary>
        /// Gets or Sets the Pediatric Guide
        /// </summary>
        public string? PediatricGuide { get; set; }
        /// <summary>
        /// Gets or Sets the Vaccine Detail
        /// </summary>
        public string? VaccineDetail { get; set; }
        /// <summary>
        /// Gets or Sets Reminder
        /// </summary>
        public string? Reminder { get; set; }
    
}
}
